/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material;

import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedOreTE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Blocks;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BW_MetaGenerated_Ores
extends BW_MetaGenerated_Blocks {
    public BW_MetaGenerated_Ores(Material p_i45386_1_, Class<? extends TileEntity> tileEntity, String blockName) {
        super(p_i45386_1_, tileEntity, blockName);
    }

    @Override
    protected void doRegistrationStuff(Werkstoff w) {
        if (w != null) {
            if (!w.hasItemType(OrePrefixes.ore) || (w.getGenerationFeatures().blacklist & 8) != 0) {
                return;
            }
            GT_ModHandler.addValuableOre((Block)this, (int)w.getmID(), (int)1);
            GT_LanguageManager.addStringLocalization((String)(this.func_149739_a() + "." + w.getmID() + ".name"), (String)(w.getDefaultName() + OrePrefixes.ore.mLocalizedMaterialPost));
        }
    }

    public static boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int aMetaData, boolean air, Block block, int[] aBlockMeta) {
        if (!air) {
            aY = Math.min(aWorld.func_72940_L(), Math.max(aY, 1));
        }
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        Block tOreBlock = WerkstoffLoader.BWOres;
        if (aMetaData < 0 || tBlock == Blocks.field_150350_a && !air) {
            return false;
        }
        if (Block.func_149682_b((Block)tBlock) != Block.func_149682_b((Block)block)) {
            return false;
        }
        int aaY = aY;
        if (Arrays.stream(aBlockMeta).noneMatch(e -> e == aWorld.func_72805_g(aX, aaY, aZ))) {
            return false;
        }
        aWorld.func_147465_d(aX, aY, aZ, tOreBlock, aMetaData, 0);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BW_MetaGeneratedOreTE) {
            ((BW_MetaGeneratedOreTE)tTileEntity).mMetaData = (short)aMetaData;
        }
        return true;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public IIcon func_149673_e(IBlockAccess p_149673_1_, int p_149673_2_, int p_149673_3_, int p_149673_4_, int p_149673_5_) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public int getHarvestLevel(int metadata) {
        return 3;
    }

    public String func_149739_a() {
        return "bw.blockores.01";
    }

    public void func_149666_a(Item aItem, CreativeTabs aTab, List aList) {
        for (Werkstoff tMaterial : Werkstoff.werkstoffHashSet) {
            if (tMaterial == null || !tMaterial.hasItemType(OrePrefixes.ore) || (tMaterial.getGenerationFeatures().blacklist & 8) != 0) continue;
            aList.add(new ItemStack(aItem, 1, (int)tMaterial.getmID()));
        }
    }

    private boolean checkForAir(IBlockAccess aWorld, int aX, int aY, int aZ) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0 || !aWorld.func_147439_a(aX + x, aY + y, aZ + z).isAir(aWorld, aX + x, aY + y, aZ + z)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

